<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-09 17:27:52
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Index
 * @method bannersByParams(array $params) 轮播图
 * @method getBrandRecommendByParams(array $params) 获取全部推荐产品
 * @method getCatalogueListByParams(array $params) 获取目录list
 * @method getCatalogueListIdsByParams(array $params) 获取目录列表的产品id
 * @method popupWindowByParams(array $params) 获取产品弹窗图片
 */
class Index {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Index\\Index";

    /**
     * 轮播图
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Index\IndexBannerDTO
    */
    public static function banners (int $cityId, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->banners(["cityId" => $cityId, "channel" => $channel]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Index\IndexBannerDTO"
        );
    }
    /**
     * 获取全部推荐产品
     * @return  array
    */
    public static function getBrandRecommend (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBrandRecommend(["cityId" => $cityId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\BrandRecommendDTO[]"
        );
    }
    /**
     * 获取目录list
     * @return  array
    */
    public static function getCatalogueList (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCatalogueList(["cityId" => $cityId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\CatalogueDTO[]"
        );
    }
    /**
     * 获取目录列表的产品id
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\CatalogueMapIdsDTO
    */
    public static function getCatalogueListIds () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCatalogueListIds(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\CatalogueMapIdsDTO"
        );
    }
    /**
     * 获取产品弹窗图片
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Index\PopupDTO
    */
    public static function popupWindow (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->popupWindow(["cityId" => $cityId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Index\PopupDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}