<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-09 15:57:38
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 * @method getStoreDetailByParams(array $params) 门店详情
 * @method getCitiesByStoreTypeByParams(array $params) 获取当前有门店的所有城市
 * @method getAllStoreIdsByParams(array $params) 获取缦图所有门店ids
 * @method getStoreListByCityIdByParams(array $params) 根据城市id获取门店列表
 * @method getCityPriceAreaIdByParams(array $params) 根据城市id获取城市价格区id
 * @method getStoreListByIdsByParams(array $params) 根据门店ids获取门店信息
 * @method getAllProvinceByParams(array $params) 获取省
 * @method getCityByParams(array $params) 获取市
 * @method getAreaByParams(array $params) 获取区
 */
class Store {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Store\\Store";

    /**
     * 门店详情
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO
    */
    public static function getStoreDetail (int $storeId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreDetail(["storeId" => $storeId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO"
        );
    }
    /**
     * 获取当前有门店的所有城市
     * @return  array
    */
    public static function getCitiesByStoreType (array $storeType) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreType(["storeType" => $storeType]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityStoreDTO[]"
        );
    }
    /**
     * 获取缦图所有门店ids
     * @return  array
    */
    public static function getAllStoreIds (array $storeType) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreIds(["storeType" => $storeType]);
    }
    /**
     * 根据城市id获取门店列表
     * @return  array
    */
    public static function getStoreListByCityId (array $cityIds, array $storeType, string $type) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityId(["cityIds" => $cityIds, "storeType" => $storeType, "type" => $type]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }
    /**
     * 根据城市id获取城市价格区id
     * @return  array
    */
    public static function getCityPriceAreaId (int $cityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityPriceAreaId(["cityId" => $cityId]);
    }
    /**
     * 根据门店ids获取门店信息
     * @return  array
    */
    public static function getStoreListByIds (array $storeIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByIds(["storeIds" => $storeIds]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO[]"
        );
    }
    /**
     * 获取省
     * @return  array
    */
    public static function getAllProvince () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllProvince(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }
    /**
     * 获取市
     * @return  array
    */
    public static function getCity (int $provinceId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCity(["provinceId" => $provinceId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }
    /**
     * 获取区
     * @return  array
    */
    public static function getArea (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getArea(["cityId" => $cityId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}