<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-09 15:57:38
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Pay;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Pay
 * @method createPayOrderByParams(array $params) 创建支付单
 * @method closePayOrderByParams(array $params) 关闭支付单
 * @method getPaySignByParams(array $params) 获取支付凭证信息
 * @method zeroPayByParams(array $params) 零元支付
 */
class Pay {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Pay\\Pay";

    /**
     * 创建支付单
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Pay\CreatePayOrderDTO
    */
    public static function createPayOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\CreatePayOrderCmd $createPayOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createPayOrder($createPayOrderCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Pay\CreatePayOrderDTO"
        );
    }
    /**
     * 关闭支付单
     * @return  bool
    */
    public static function closePayOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->closePayOrder($closePayOrderCmd);
    }
    /**
     * 获取支付凭证信息
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Pay\PaySignDTO
    */
    public static function getPaySign (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\PaySignCmd $paySignCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getPaySign($paySignCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Pay\PaySignDTO"
        );
    }
    /**
     * 零元支付
     * @return  bool
    */
    public static function zeroPay (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ZeroPayCmd $zeroPayCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->zeroPay($zeroPayCmd);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}