<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-09 15:37:25
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class ProductCache
 * @method listenProductByParams(array $params) 编辑产品通知
 * @method listenCategoryByParams(array $params) 编辑类目通知
 */
class ProductCache {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "MessageHook\\ProductCache";

    /**
     * 编辑产品通知
     * @return  bool
    */
    public static function listenProduct (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenProduct(["productId" => $productId]);
    }
    /**
     * 编辑类目通知
     * @return  bool
    */
    public static function listenCategory (int $categoryId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->listenCategory(["categoryId" => $categoryId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}