<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 15:08:27
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class User
 * @method detailByParams(array $params) 用户详情
 * @method userAddressListByParams(array $params) 用户地址列表
 * @method changeAddressByParams(array $params) 修改用户地址信息
 * @method deleteUserAddressByParams(array $params) 删除用户地址
 * @method addAddressByParams(array $params) 添加用户地址信息
 * @method changeUserInfoByParams(array $params) 修改用户信息
 * @method createGuestInformationByParams(array $params) 创建客资
 * @method createGuestH5InformationByParams(array $params) 创建客资承接页
 * @method createGuestCrmInformationByParams(array $params) 创建客资承接页
 * @method createGuestGiftInformationByParams(array $params) 创建留资有礼
 * @method getGuestGiftInformationByParams(array $params) 获取留资有礼信息
 */
class User {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "User\\User";

    /**
     * 用户详情
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserDetailDTO
    */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->detail(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserDetailDTO"
        );
    }
    /**
     * 用户地址列表
     * @return  array
    */
    public static function userAddressList () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->userAddressList([]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserAddressUpdateDTO[]"
        );
    }
    /**
     * 修改用户地址信息
     * @return  bool
    */
    public static function changeAddress (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressUpdateCmd $userAddressUpdateCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeAddress($userAddressUpdateCmd);
    }
    /**
     * 删除用户地址
     * @return  bool
    */
    public static function deleteUserAddress (int $userAddressId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteUserAddress(["userAddressId" => $userAddressId]);
    }
    /**
     * 添加用户地址信息
     * @return  bool
    */
    public static function addAddress (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressCmd $userAddressCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addAddress($userAddressCmd);
    }
    /**
     * 修改用户信息
     * @return  bool
    */
    public static function changeUserInfo (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserInfoCmd $userInfoCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changeUserInfo($userInfoCmd);
    }
    /**
     * 创建客资
     * @return  bool
    */
    public static function createGuestInformation (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestCardInformationCmd $userGuestCardInformationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createGuestInformation($userGuestCardInformationCmd);
    }
    /**
     * 创建客资承接页
     * @return  bool
    */
    public static function createGuestH5Information (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestH5InformationCmd $userGuestH5InformationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createGuestH5Information($userGuestH5InformationCmd);
    }
    /**
     * 创建客资承接页
     * @return  bool
    */
    public static function createGuestCrmInformation (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestCrmInformationCmd $userGuestCrmInformationCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createGuestCrmInformation($userGuestCrmInformationCmd);
    }
    /**
     * 创建留资有礼
     * @return  bool
    */
    public static function createGuestGiftInformation (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestGiftCmd $userGuestGiftCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createGuestGiftInformation($userGuestGiftCmd);
    }
    /**
     * 获取留资有礼信息
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserGuestGiftDTO
    */
    public static function getGuestGiftInformation (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestGiftDetailCmd $userGuestGiftDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getGuestGiftInformation($userGuestGiftDetailCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserGuestGiftDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}