<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 15:08:27
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Coupon
 * @method couponListByParams(array $params) 优惠券列表
 * @method storeCouponListByParams(array $params) 根据门店优惠券列表
 * @method bindCouponByParams(array $params) 用户绑定优惠券
 */
class Coupon {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Preferential\\Coupon";

    /**
     * 优惠券列表
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponListDTO
    */
    public static function couponList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Preferential\CouponListCmd $couponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->couponList($couponListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponListDTO"
        );
    }
    /**
     * 根据门店优惠券列表
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponListDTO
    */
    public static function storeCouponList (int $storeId, array $productId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->storeCouponList(["storeId" => $storeId, "productId" => $productId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponListDTO"
        );
    }
    /**
     * 用户绑定优惠券
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponDTO
    */
    public static function bindCoupon (string $couponCode) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->bindCoupon(["couponCode" => $couponCode]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}