<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 15:08:27
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 * @method createOrderByParams(array $params) 创建订单
 * @method orderDetailByParams(array $params) 订单详情
 * @method orderListByParams(array $params) 订单列表
 * @method changReserveTimeByParams(array $params) 修改预约时间
 * @method orderPhotoByParams(array $params) 下载成片
 * @method deleteOrderByParams(array $params) 删除订单
 * @method getCompleteOrderPhotoByParams(array $params) 获取完成订单的下载成片
 * @method cancelOrderByParams(array $params) 取消订单
 * @method getBuyShowByParams(array $params) 组合买家秀数据
 */
class Order {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Order\\Order";

    /**
     * 创建订单
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CreateOrderDTO
    */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrder($createOrderCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CreateOrderDTO"
        );
    }
    /**
     * 订单详情
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderDetailDTO
    */
    public static function orderDetail (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderDetailCmd $orderDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetail($orderDetailCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderDetailDTO"
        );
    }
    /**
     * 订单列表
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderListDTO
    */
    public static function orderList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderListCmd $orderListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderList($orderListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderListDTO"
        );
    }
    /**
     * 修改预约时间
     * @return  bool
    */
    public static function changReserveTime (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\ChangeReserveTimeCmd $changeReserveTimeCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->changReserveTime($changeReserveTimeCmd);
    }
    /**
     * 下载成片
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderPhotoDTO
    */
    public static function orderPhoto (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $orderPhotoCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderPhoto($orderPhotoCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderPhotoDTO"
        );
    }
    /**
     * 删除订单
     * @return  bool
    */
    public static function deleteOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderCmd $orderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrder($orderCmd);
    }
    /**
     * 获取完成订单的下载成片
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CompleteOrderListDTO
    */
    public static function getCompleteOrderPhoto (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\CompleteOrderPhotoCmd $completeOrderPhotoCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCompleteOrderPhoto($completeOrderPhotoCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CompleteOrderListDTO"
        );
    }
    /**
     * 取消订单
     * @return  bool
    */
    public static function cancelOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderCmd $orderCmd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder($orderCmd);
    }
    /**
     * 组合买家秀数据
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\BuyerShow\BuyerShowInfoDTO
    */
    public static function getBuyShow (string $orderNum, int $userId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBuyShow(["orderNum" => $orderNum, "userId" => $userId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\BuyerShow\BuyerShowInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}