<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-16 15:08:27
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 * @method orderFinishByParams(array $params) 拍摄完成通知
 * @method lookPhotoOrderFinishByParams(array $params) 看片订单完成通知
 * @method sendAppointmentNoticeByParams(array $params) 预约成功通知
 * @method makePhotoAlbumByParams(array $params) 相框制作通知
 * @method logisticsByParams(array $params) 物流发货通知
 */
class Order {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "MessageHook\\Order";

    /**
     * 拍摄完成通知
     * @return  bool
    */
    public static function orderFinish (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->orderFinish(["orderId" => $orderId]);
    }
    /**
     * 看片订单完成通知
     * @return  bool
    */
    public static function lookPhotoOrderFinish (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->lookPhotoOrderFinish(["orderId" => $orderId]);
    }
    /**
     * 预约成功通知
     * @return  bool
    */
    public static function sendAppointmentNotice (int $order_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendAppointmentNotice(["order_id" => $order_id]);
    }
    /**
     * 相框制作通知
     * @return  bool
    */
    public static function makePhotoAlbum (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->makePhotoAlbum(["orderId" => $orderId]);
    }
    /**
     * 物流发货通知
     * @return  bool
    */
    public static function logistics (int $orderId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logistics(["orderId" => $orderId]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}