<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2024-04-08 15:59:17
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 * @method getCouldPhotoCityByParams(array $params) 获取产品可拍摄城市
 * @method getCouldPhotoStoreByParams(array $params) 获取产品可拍摄门店
 * @method getCouldPhotoAllStoreByParams(array $params) 获取产品全部拍摄门店
 * @method addWantTakeProductByParams(array $params) 添加想拍产品
 * @method cancelWantTakeProductByParams(array $params) 取消想拍产品
 * @method productInfoByParams(array $params) 产品详情
 * @method productListByParams(array $params) 产品列表
 * @method productAllInfoByParams(array $params) 全部产品
 * @method samplePieceByParams(array $params) 想拍产品列表
 * @method productSeriesListByParams(array $params) 套系列表
 * @method getStoreProductTreeByParams(array $params) 获取门店产品树列表
 */
class Product {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Product\\Product";

    /**
     * 获取产品可拍摄城市
     * @return  array
    */
    public static function getCouldPhotoCity (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoCity(["productId" => $productId]);
    }
    /**
     * 获取产品可拍摄门店
     * @return  array
    */
    public static function getCouldPhotoStore (array $productIds, int $cityId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoStore(["productIds" => $productIds, "cityId" => $cityId]);
    }
    /**
     * 获取产品全部拍摄门店
     * @return  array
    */
    public static function getCouldPhotoAllStore (int $productId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoAllStore(["productId" => $productId]);
    }
    /**
     * 添加想拍产品
     * @return  bool
    */
    public static function addWantTakeProduct (int $productId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->addWantTakeProduct(["productId" => $productId, "type" => $type]);
    }
    /**
     * 取消想拍产品
     * @return  bool
    */
    public static function cancelWantTakeProduct (int $productId, string $type) {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelWantTakeProduct(["productId" => $productId, "type" => $type]);
    }
    /**
     * 产品详情
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO
    */
    public static function productInfo (int $productId) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productInfo(["productId" => $productId]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO"
        );
    }
    /**
     * 产品列表
     * @return  array
    */
    public static function productList (array $productIds) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productList(["productIds" => $productIds]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]"
        );
    }
    /**
     * 全部产品
     * @return  array
    */
    public static function productAllInfo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->productAllInfo();
    }
    /**
     * 想拍产品列表
     * @return  array
    */
    public static function samplePiece () {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->samplePiece([]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]"
        );
    }
    /**
     * 套系列表
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductSeriesListDTO
    */
    public static function productSeriesList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Product\ProductSeriesListCmd $productSeriesListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productSeriesList($productSeriesListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductSeriesListDTO"
        );
    }
    /**
     * 获取门店产品树列表
     * @return  array
    */
    public static function getStoreProductTree (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Product\ProductSeriesListCmd $productSeriesListCmd) {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreProductTree($productSeriesListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\StoreProductTreeDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}