<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-16 13:51:39
 */
namespace Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay;

class CreatePayOrderCmd {
    /**
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\PayOrderCmd[]
     * 创建的支付订单的订单信息
     * validation: max:1
     */
    public array $orders;
    /**
     * @var  string
     * 用户openId
     * validation: 
     */
    public string $openId = "";
    /**
     * @var  float
     * 支付金额
     * validation: 
     */
    public float $payMoney;
    /**
     * @var  string
     * 支付类型
     * validation: in:PaymaxAlipay,PaymaxWechat,PaymaxWXApp
     */
    public string $payType;

    public function __construct (int $currentUserId = 0, array $orders = [], float $payMoney = 0.0, string $payType = '') {
        $this->currentUserId = $currentUserId;
        $this->orders = $orders;
        $this->payMoney = $payMoney;
        $this->payType = $payType;
    }

    public static function create(int $currentUserId = 0, array $orders = [], float $payMoney = 0.0, string $payType = ''): self {
        return new self($currentUserId, $orders, $payMoney, $payType);
    }

    public function setOrders(array $orders): self {
        $this->orders = $orders;

        return $this;
    }

    public function setOpenId(string $openId): self {
        $this->openId = $openId;

        return $this;
    }

    public function setPayMoney(float $payMoney): self {
        $this->payMoney = $payMoney;

        return $this;
    }

    public function setPayType(string $payType): self {
        $this->payType = $payType;

        return $this;
    }
}