<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-16 13:51:39
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Store
 */
class Store {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Store\\Store";

    /**
     * 门店详情
     */
    public static function getStoreDetail (int $storeId): \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreDetail(["storeId" => $storeId, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO"
        );
    }
    /**
     * 获取当前有门店的所有城市
     */
    public static function getCitiesByStoreType (array $storeType): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCitiesByStoreType(["storeType" => $storeType, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityStoreDTO[]"
        );
    }
    /**
     * 获取缦图所有门店ids
     */
    public static function getAllStoreIds (array $storeType): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAllStoreIds(["storeType" => $storeType, ]);
    }
    /**
     * 根据城市id获取门店列表
     */
    public static function getStoreListByCityId (array $cityIds, array $storeType, string $type): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByCityId(["cityIds" => $cityIds, "storeType" => $storeType, "type" => $type, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }
    /**
     * 根据城市id获取城市价格区id
     */
    public static function getCityPriceAreaId (int $cityId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCityPriceAreaId(["cityId" => $cityId, ]);
    }
    /**
     * 根据门店ids获取门店信息
     */
    public static function getStoreListByIds (array $storeIds): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreListByIds(["storeIds" => $storeIds, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO[]"
        );
    }
    /**
     * 获取省
     */
    public static function getAllProvince (): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getAllProvince(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }
    /**
     * 获取市
     */
    public static function getCity (int $provinceId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCity(["provinceId" => $provinceId, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }
    /**
     * 获取区
     */
    public static function getArea (int $cityId): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getArea(["cityId" => $cityId, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}