<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-16 13:51:39
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Product
 */
class Product {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Product\\Product";

    /**
     * 获取产品可拍摄城市
     */
    public static function getCouldPhotoCity (int $productId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoCity(["productId" => $productId, ]);
    }
    /**
     * 获取产品可拍摄门店
     */
    public static function getCouldPhotoStore (array $productIds, int $cityId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoStore(["productIds" => $productIds, "cityId" => $cityId, ]);
    }
    /**
     * 获取产品全部拍摄门店
     */
    public static function getCouldPhotoAllStore (int $productId): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->getCouldPhotoAllStore(["productId" => $productId, ]);
    }
    /**
     * 添加想拍产品
     */
    public static function addWantTakeProduct (int $productId, string $type): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->addWantTakeProduct(["productId" => $productId, "type" => $type, ]);
    }
    /**
     * 取消想拍产品
     */
    public static function cancelWantTakeProduct (int $productId, string $type): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelWantTakeProduct(["productId" => $productId, "type" => $type, ]);
    }
    /**
     * 产品详情
     */
    public static function productInfo (int $productId): \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productInfo(["productId" => $productId, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO"
        );
    }
    /**
     * 产品列表
     */
    public static function productList (array $productIds): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productList(["productIds" => $productIds, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]"
        );
    }
    /**
     * 全部产品
     */
    public static function productAllInfo (): array {
        return RpcClass::getClass(self::$serviceName, self::$className)->productAllInfo();
    }
    /**
     * 想拍产品列表
     */
    public static function samplePiece (int $page = 1, int $pageSize = 10): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->samplePiece(["page" => $page, "pageSize" => $pageSize, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]"
        );
    }
    /**
     * 套系列表
     */
    public static function productSeriesList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Product\ProductSeriesListCmd $productSeriesListCmd): \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductSeriesListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->productSeriesList($productSeriesListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductSeriesListDTO"
        );
    }
    /**
     * 获取门店产品树列表
     */
    public static function getStoreProductTree (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Product\ProductSeriesListCmd $productSeriesListCmd): array {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getStoreProductTree($productSeriesListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\StoreProductTreeDTO[]"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}