<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-03-07 11:31:09
 */
namespace Mainto\Bridge\Structs\ProjectMainto\Cmd\User;

class UserGuestCardInformationCmd {
    /**
     * @var  string
     * 客户预约时间段
     * validation: in:three_month,six_month,one_year,future_year
     */
    public string $reserveTime;
    /**
     * @var  int
     * 用户手机号
     * validation: sometimes|min:11|max:11
     */
    public int $phone;
    /**
     * @var  string
     * 用户微信号
     * validation: 
     */
    public string $wechat;
    /**
     * @var  int
     * 城市Id
     * validation: 
     */
    public int $cityId;
    /**
     * @var  string
     * 拍摄类型
     * validation: in:xiezhen,mantu,mantu_guofeng
     */
    public string $photographyType;
    /**
     * @var  string
     * 客资类型
     * validation: in:appointment_consult,appointment_polite,himo_guest
     */
    public string $guestType = "appointment_polite";
    /**
     * @var  string
     * 用户备注
     * validation: max:300
     */
    public string $note;

    public function __construct (int $userId = 0, string $reserveTime = '', int $phone = 0, string $wechat = '', int $cityId = 0, string $photographyType = '', string $note = '') {
        $this->userId = $userId;
        $this->reserveTime = $reserveTime;
        $this->phone = $phone;
        $this->wechat = $wechat;
        $this->cityId = $cityId;
        $this->photographyType = $photographyType;
        $this->note = $note;
    }

    public static function create(int $userId = 0, string $reserveTime = '', int $phone = 0, string $wechat = '', int $cityId = 0, string $photographyType = '', string $note = ''): self {
        return new self($userId, $reserveTime, $phone, $wechat, $cityId, $photographyType, $note);
    }

    public function setReserveTime(string $reserveTime): self {
        $this->reserveTime = $reserveTime;

        return $this;
    }

    public function setPhone(int $phone): self {
        $this->phone = $phone;

        return $this;
    }

    public function setWechat(string $wechat): self {
        $this->wechat = $wechat;

        return $this;
    }

    public function setCityId(int $cityId): self {
        $this->cityId = $cityId;

        return $this;
    }

    public function setPhotographyType(string $photographyType): self {
        $this->photographyType = $photographyType;

        return $this;
    }

    public function setGuestType(string $guestType): self {
        $this->guestType = $guestType;

        return $this;
    }

    public function setNote(string $note): self {
        $this->note = $note;

        return $this;
    }
}