<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-26 10:33:33
 */
namespace Mainto\Bridge\Invokes\ProjectMainto\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Order
 */
class Order {
    private static string $serviceName = "ProjectMainto";

    private static string $className = "Order\\Order";

    /**
     * 创建订单
     *
     */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\CreateOrderCmd $createOrderCmd): \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CreateOrderDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->createOrder($createOrderCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CreateOrderDTO"
        );
    }
    /**
     * 订单详情
     *
     */
    public static function orderDetail (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderDetailCmd $orderDetailCmd): \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderDetailDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderDetail($orderDetailCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderDetailDTO"
        );
    }
    /**
     * 订单列表
     *
     */
    public static function orderList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderListCmd $orderListCmd): \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderList($orderListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderListDTO"
        );
    }
    /**
     * 修改预约时间
     *
     */
    public static function changReserveTime (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\ChangeReserveTimeCmd $changeReserveTimeCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->changReserveTime($changeReserveTimeCmd);
    }
    /**
     * 下载成片
     *
     */
    public static function orderPhoto (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $orderPhotoCmd): \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderPhotoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->orderPhoto($orderPhotoCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderPhotoDTO"
        );
    }
    /**
     * 删除订单
     *
     */
    public static function deleteOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderCmd $orderCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->deleteOrder($orderCmd);
    }
    /**
     * 获取完成订单的下载成片
     *
     */
    public static function getCompleteOrderPhoto (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\CompleteOrderPhotoCmd $completeOrderPhotoCmd): \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CompleteOrderListDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getCompleteOrderPhoto($completeOrderPhotoCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CompleteOrderListDTO"
        );
    }
    /**
     * 取消订单
     *
     */
    public static function cancelOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderCmd $orderCmd): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->cancelOrder($orderCmd);
    }
    /**
     * 组合买家秀数据
     *
     */
    public static function getBuyShow (string $orderNum, int $userId): \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\BuyerShow\BuyerShowInfoDTO {
        return app('json_mapper')->mapUseTypeString(
            RpcClass::getClass(self::$serviceName, self::$className)->getBuyShow(["orderNum" => $orderNum, "userId" => $userId, ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\BuyerShow\BuyerShowInfoDTO"
        );
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}