<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderFinishByParams(array $params)
 * @method lookPhotoOrderFinishByParams(array $params)
 * @method sendAppointmentNoticeByParams(array $params)
 * @method makePhotoAlbumByParams(array $params)
 * @method logisticsByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 拍摄完成通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderFinish (int $orderId) {
        return self::getClass()->orderFinish([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 看片订单完成通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function lookPhotoOrderFinish (int $orderId) {
        return self::getClass()->lookPhotoOrderFinish([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 预约成功通知
     *
     * @param  int $order_id 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendAppointmentNotice (int $order_id) {
        return self::getClass()->sendAppointmentNotice([
            "order_id" => $order_id,
        ]);
    }

    /**
     * 相框制作通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function makePhotoAlbum (int $orderId) {
        return self::getClass()->makePhotoAlbum([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 物流发货通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function logistics (int $orderId) {
        return self::getClass()->logistics([
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'MessageHook\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'MessageHook\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}