<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Question;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getNpsStatusByParams(array $params)
 * @method submitNpsByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Question\NpsCmd $params)
 */
class Nps {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取Nps状态
     *
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getNpsStatus (int $orderId) {
        return self::getClass()->getNpsStatus([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 提交Nps
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Question\NpsCmd $snCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitNps (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Question\NpsCmd $snCmd) {
        return self::getClass()->submitNps($snCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Question\Nps');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Question\Nps');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}