<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getStoreDetailByParams(array $params)
 * @method getCitiesByStoreTypeByParams(array $params)
 * @method getAllStoreIdsByParams(array $params)
 * @method getStoreListByCityIdByParams(array $params)
 * @method getStoreListByIdsByParams(array $params)
 * @method getAllProvinceByParams(array $params)
 * @method getCityByParams(array $params)
 * @method getAreaByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店详情
     *
     * @support  int $storeId 门店id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO
     */
    public static function getStoreDetail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreDetail([
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO"
        );
    }

    /**
     * 获取当前有门店的所有城市
     *
     * @param  array $storeType 门店类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityStoreDTO[]
     */
    public static function getCitiesByStoreType (array $storeType) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCitiesByStoreType([
                            "storeType" => $storeType,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 获取缦图所有门店ids
     *
     * @param  array $storeType 门店类型 [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getAllStoreIds (array $storeType) {
        return self::getClass()->getAllStoreIds([
            "storeType" => $storeType,
        ]);
    }

    /**
     * 根据城市id获取门店列表
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @support  array $storeType 门店类型 [ require true ]
     * @support  string $type 获取数据基本类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreAdvancedInfoDTO[]
     */
    public static function getStoreListByCityId () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreListByCityId([
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * 根据门店ids获取门店信息
     *
     * @param  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO[]
     */
    public static function getStoreListByIds (array $storeIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreListByIds([
                            "storeIds" => $storeIds,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO[]"
        );
    }

    /**
     * 获取省
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]
     */
    public static function getAllProvince () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAllProvince(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }

    /**
     * 获取市
     *
     * @param  int $provinceId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]
     */
    public static function getCity (int $provinceId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCity([
                            "provinceId" => $provinceId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }

    /**
     * 获取区
     *
     * @param  int $cityId 门店ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]
     */
    public static function getArea (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getArea([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}