<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Question;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getSnByParams(array $params)
 * @method getSnStatusByParams(array $params)
 * @method submitSnByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Question\SnCmd $params)
 */
class Sn {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取SN问卷
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Question\QuestionDTO[]
     */
    public static function getSn () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getSn(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Question\QuestionDTO[]"
        );
    }

    /**
     * 获取SN状态
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function getSnStatus (string $orderNo) {
        return self::getClass()->getSnStatus([
            "orderNo" => $orderNo,
        ]);
    }

    /**
     * 提交问卷
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Question\SnCmd $snCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function submitSn (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Question\SnCmd $snCmd) {
        return self::getClass()->submitSn($snCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Question\Sn');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Question\Sn');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}