<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bannerChangeByParams(array $params)
 * @method recommendConfigChangeByParams(array $params)
 * @method recommendClassificationChangeByParams(array $params)
 */
class Index {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * banner变更消息推送
     *
     * @param  array $newCityIds 新增的bannerid [ require false ]
     * @param  array $oldCityIds 存在的bannerid [ require false ]
     * @param  string $channel 对应类型的id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function bannerChange (string $channel, array $newCityIds = [], array $oldCityIds = []) {
        return self::getClass()->bannerChange([
            "channel" => $channel,
            "newCityIds" => $newCityIds,
            "oldCityIds" => $oldCityIds,
        ]);
    }

    /**
     * 推荐产品配置变更通知
     *
     * @param  array $cityIds 城市ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recommendConfigChange (array $cityIds) {
        return self::getClass()->recommendConfigChange([
            "cityIds" => $cityIds,
        ]);
    }

    /**
     * 推荐产品配置变更通知
     *
     * @param  array $cityIds 城市ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function recommendClassificationChange (array $cityIds) {
        return self::getClass()->recommendClassificationChange([
            "cityIds" => $cityIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'MessageHook\Index');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'MessageHook\Index');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}