<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\ShareOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method shareProductTagListByParams(array $params)
 * @method shareOrderDetailByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderInfoCmd $params)
 * @method shareOrderListByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderListCmd $params)
 * @method setIsLikeRecordByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\SetIsLikeRecordCmd $params)
 * @method getLikeRecordByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\GetIsLikeRecordCmd $params)
 * @method addBuyerShowByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\BuyerShowCreate\CreateBuyerShowCmd $params)
 * @method updateBuyerShowByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\BuyerShowCreate\UpdateBuyerShowCmd $params)
 * @method deleteBuyerShowByParams(array $params)
 * @method buyerShowOrderInfoByParams(array $params)
 * @method styleBuyerShowByParams(array $params)
 */
class ShareOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 买家秀标签列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareProductTagDTO[]
     */
    public static function shareProductTagList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareProductTagList(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareProductTagDTO[]"
        );
    }

    /**
     * 买家秀详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderInfoCmd $shareOrderInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderDetailDTO
     */
    public static function shareOrderDetail (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderInfoCmd $shareOrderInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareOrderDetail($shareOrderInfoCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderDetailDTO"
        );
    }


    /**
     * 买家秀列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderListCmd $shareOrderListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderListDTO
     */
    public static function shareOrderList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderListCmd $shareOrderListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareOrderList($shareOrderListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderListDTO"
        );
    }


    /**
     * 设置买家秀点赞信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\SetIsLikeRecordCmd $setIsLikeRecordCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setIsLikeRecord (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\SetIsLikeRecordCmd $setIsLikeRecordCmd) {
        return self::getClass()->setIsLikeRecord($setIsLikeRecordCmd);
    }


    /**
     * 获取买家秀点赞信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\GetIsLikeRecordCmd $getIsLikeRecordCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderListDTO
     */
    public static function getLikeRecord (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\GetIsLikeRecordCmd $getIsLikeRecordCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getLikeRecord($getIsLikeRecordCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderListDTO"
        );
    }


    /**
     * 添加买家秀
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\BuyerShowCreate\CreateBuyerShowCmd $createBuyerShowCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function addBuyerShow (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\BuyerShowCreate\CreateBuyerShowCmd $createBuyerShowCmd) {
        return self::getClass()->addBuyerShow($createBuyerShowCmd);
    }


    /**
     * 更新买家秀
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\BuyerShowCreate\UpdateBuyerShowCmd $updateBuyerShowCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function updateBuyerShow (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\BuyerShowCreate\UpdateBuyerShowCmd $updateBuyerShowCmd) {
        return self::getClass()->updateBuyerShow($updateBuyerShowCmd);
    }


    /**
     * 删除买家秀
     *
     * @param  int $shareOrderId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteBuyerShow (int $shareOrderId) {
        return self::getClass()->deleteBuyerShow([
            "shareOrderId" => $shareOrderId,
        ]);
    }

    /**
     * 订单卖家秀信息
     *
     * @param  array $orderNums 订单编号 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderNumDetailDTO
     */
    public static function buyerShowOrderInfo (array $orderNums) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->buyerShowOrderInfo([
                            "orderNums" => $orderNums,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderNumDetailDTO"
        );
    }

    /**
     * 是否可以晒单
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function styleBuyerShow () {
        return self::getClass()->styleBuyerShow();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'ShareOrder\ShareOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'ShareOrder\ShareOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}