<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method detailByParams(array $params)
 * @method userAddressListByParams(array $params)
 * @method changeAddressByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressUpdateCmd $params)
 * @method deleteUserAddressByParams(array $params)
 * @method addAddressByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressCmd $params)
 * @method changeUserInfoByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserInfoCmd $params)
 * @method createGuestInformationByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestCardInformationCmd $params)
 * @method createH5GuestInformationByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestInformationCmd $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户详情
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserDetailDTO
     */
    public static function detail () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->detail(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserDetailDTO"
        );
    }

    /**
     * 用户地址列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 页数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserAddressUpdateDTO[]
     */
    public static function userAddressList (int $page = 1, int $pageSize = 199) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->userAddressList([
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\User\UserAddressUpdateDTO[]"
        );
    }

    /**
     * 修改用户地址信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressUpdateCmd $userAddress
     * @throws  \Exception
     * @return  bool
     */
    public static function changeAddress (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressUpdateCmd $userAddress) {
        return self::getClass()->changeAddress($userAddress);
    }


    /**
     * 删除用户地址
     *
     * @param  int $userAddressId 用户地址Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteUserAddress (int $userAddressId) {
        return self::getClass()->deleteUserAddress([
            "userAddressId" => $userAddressId,
        ]);
    }

    /**
     * 添加用户地址信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressCmd $userAddress
     * @throws  \Exception
     * @return  bool
     */
    public static function addAddress (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserAddressCmd $userAddress) {
        return self::getClass()->addAddress($userAddress);
    }


    /**
     * 修改用户信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserInfoCmd $userInfoCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changeUserInfo (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserInfoCmd $userInfoCmd) {
        return self::getClass()->changeUserInfo($userInfoCmd);
    }


    /**
     * 创建客资
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestCardInformationCmd $userGuestInformationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createGuestInformation (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestCardInformationCmd $userGuestInformationCmd) {
        return self::getClass()->createGuestInformation($userGuestInformationCmd);
    }


    /**
     * 创建客资
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestInformationCmd $userGuestInformationCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function createH5GuestInformation (\Mainto\Bridge\Structs\ProjectMainto\Cmd\User\UserGuestInformationCmd $userGuestInformationCmd) {
        return self::getClass()->createH5GuestInformation($userGuestInformationCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}