<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cronOrderAutoServiceCompleteByParams(array $params)
 * @method cronOrderSaleSkuAutoServiceCompleteByParams(array $params)
 * @method cronOrderUpgradeSkuAutoServiceCompleteByParams(array $params)
 * @method lookPhotoAutoCompleteByParams(array $params)
 * @method pictureOnlineLookPhotoAutoCompleteByParams(array $params)
 */
class Cron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天13点到15点，每5分钟执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cronOrderAutoServiceComplete (string $day = '') {
        return self::getClass()->cronOrderAutoServiceComplete([
            "day" => $day,
        ]);
    }

    /**
     * 每天13点到15点，每5分钟执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cronOrderSaleSkuAutoServiceComplete (string $day = '') {
        return self::getClass()->cronOrderSaleSkuAutoServiceComplete([
            "day" => $day,
        ]);
    }

    /**
     * 每天13点到15点，每5分钟执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cronOrderUpgradeSkuAutoServiceComplete (string $day = '') {
        return self::getClass()->cronOrderUpgradeSkuAutoServiceComplete([
            "day" => $day,
        ]);
    }

    /**
     * 每天13点到15点，每5分钟执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function lookPhotoAutoComplete (string $day = '') {
        return self::getClass()->lookPhotoAutoComplete([
            "day" => $day,
        ]);
    }

    /**
     * 每天13点到15点，每5分钟执行一次
     *
     * @param  string $day 需要执行的日期 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function pictureOnlineLookPhotoAutoComplete (string $day = '') {
        return self::getClass()->pictureOnlineLookPhotoAutoComplete([
            "day" => $day,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Cron\Cron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Cron\Cron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}