<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listenProductByParams(array $params)
 * @method listenCategoryByParams(array $params)
 */
class ProductCache {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 编辑产品通知
     *
     * @param  int $productId 产品id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenProduct (int $productId) {
        return self::getClass()->listenProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 编辑类目通知
     *
     * @param  int $categoryId 类目id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function listenCategory (int $categoryId) {
        return self::getClass()->listenCategory([
            "categoryId" => $categoryId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'MessageHook\ProductCache');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'MessageHook\ProductCache');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}