<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method bannersByParams(array $params)
 * @method getBrandRecommendByParams(array $params)
 * @method getCatalogueListByParams(array $params)
 */
class Index {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 轮播图
     *
     * @param  int $cityId 当前城市id [ require true ]
     * @param  string $channel 模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Index\IndexBannerDTO
     */
    public static function banners (int $cityId, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->banners([
                            "cityId" => $cityId,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Index\IndexBannerDTO"
        );
    }

    /**
     * 获取全部推荐产品
     *
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\BrandRecommendDTO[]
     */
    public static function getBrandRecommend (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBrandRecommend([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\BrandRecommendDTO[]"
        );
    }

    /**
     * 获取目录list
     *
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\CatalogueDTO[]
     */
    public static function getCatalogueList (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCatalogueList([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\CatalogueDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Index\Index');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Index\Index');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}