<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderFinishByParams(array $params)
 * @method sendNormalNotifyByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单完成通知
     *
     * @param  int $orderId 城市ids [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderFinish (int $orderId) {
        return self::getClass()->orderFinish([
            "orderId" => $orderId,
        ]);
    }

    /**
     * 看片通知
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $type 类型 [ require false ]
     * @support  string $module 订单模块 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNormalNotify () {
        return self::getClass()->sendNormalNotify([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'MessageQueue\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'MessageQueue\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}