<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\CreateOrderCmd $params)
 * @method orderDetailByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderDetailCmd $params)
 * @method orderListByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderListCmd $params)
 * @method changReserveTimeByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\ChangeReserveTimeCmd $params)
 * @method orderPhotoByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $params)
 * @method deleteOrderByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建订单
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\CreateOrderCmd $createOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CreateOrderDTO
     */
    public static function createOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\CreateOrderCmd $createOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createOrder($createOrderCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\CreateOrderDTO"
        );
    }


    /**
     * 订单详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderDetailCmd $orderDetailCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderDetailDTO
     */
    public static function orderDetail (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderDetailCmd $orderDetailCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderDetail($orderDetailCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderDetailDTO"
        );
    }


    /**
     * 订单列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderListCmd $orderListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderListDTO
     */
    public static function orderList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderListCmd $orderListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderList($orderListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderListDTO"
        );
    }


    /**
     * 修改预约时间
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\ChangeReserveTimeCmd $changeReserveTimeCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function changReserveTime (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\ChangeReserveTimeCmd $changeReserveTimeCmd) {
        return self::getClass()->changReserveTime($changeReserveTimeCmd);
    }


    /**
     * 下载成片
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $orderPhotoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderPhotoDTO
     */
    public static function orderPhoto (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $orderPhotoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->orderPhoto($orderPhotoCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderPhotoDTO"
        );
    }


    /**
     * 删除订单
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $orderPhotoCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderPhotoCmd $orderPhotoCmd) {
        return self::getClass()->deleteOrder($orderPhotoCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}