<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouldPhotoCityByParams(array $params)
 * @method getCouldPhotoStoreByParams(array $params)
 * @method addWantTakeProductByParams(array $params)
 * @method cancelWantTakeProductByParams(array $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品可拍摄城市
     *
     * @param  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getCouldPhotoCity (int $productId) {
        return self::getClass()->getCouldPhotoCity([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品可拍摄门店
     *
     * @param  array $productIds 产品Ids [ require true ]
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getCouldPhotoStore (array $productIds, int $cityId) {
        return self::getClass()->getCouldPhotoStore([
            "productIds" => $productIds,
            "cityId" => $cityId,
        ]);
    }

    /**
     * 添加想拍产品
     *
     * @param  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addWantTakeProduct (int $productId) {
        return self::getClass()->addWantTakeProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * 取消想拍产品
     *
     * @param  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelWantTakeProduct (int $productId) {
        return self::getClass()->cancelWantTakeProduct([
            "productId" => $productId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}