<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Index;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getBrandRecommendByParams(array $params)
 * @method getCatalogueListByParams(array $params)
 * @method bannersByParams(array $params)
 * @method getLogisticsInfoByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderLogisticsCmd $params)
 */
class Index {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取全部推荐产品
     *
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\BrandRecommendDTO[]
     */
    public static function getBrandRecommend (int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getBrandRecommend([
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\BrandRecommendDTO[]"
        );
    }

    /**
     * 获取目录list
     *
     * @param  string $brand 对应类型的id [ require true ]
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\CatalogueDTO[]
     */
    public static function getCatalogueList (string $brand, int $cityId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCatalogueList([
                            "brand" => $brand,
                            "cityId" => $cityId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\CatalogueDTO[]"
        );
    }

    /**
     * banners
     *
     * @param  int $cityId 当前城市id [ require true ]
     * @param  string $channel 模块 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Index\IndexBannerDTO
     */
    public static function banners (int $cityId, string $channel) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->banners([
                            "cityId" => $cityId,
                            "channel" => $channel,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Index\IndexBannerDTO"
        );
    }

    /**
     * 获取物流详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderLogisticsCmd $orderLogisticsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderLogisticsDTO
     */
    public static function getLogisticsInfo (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderLogisticsCmd $orderLogisticsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getLogisticsInfo($orderLogisticsCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderLogisticsDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Index\Index');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Index\Index');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}