<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Preferential;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method couponListByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Preferential\CouponListCmd $params)
 * @method bindCouponByParams(array $params)
 */
class Coupon {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 优惠券列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Preferential\CouponListCmd $couponListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponListDTO
     */
    public static function couponList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Preferential\CouponListCmd $couponListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->couponList($couponListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponListDTO"
        );
    }


    /**
     * 用户绑定优惠券
     *
     * @support  string $couponCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponDTO
     */
    public static function bindCoupon () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->bindCoupon([
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Preferential\CouponDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Preferential\Coupon');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Preferential\Coupon');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}