<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderFinishByParams(array $params)
 * @method sendAppointmentNoticeByParams(array $params)
 * @method makePhotoAlbumByParams(array $params)
 * @method logisticsByParams(array $params)
 * @method sendPayUrlByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单完成通知
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderFinish (string $orderNum) {
        return self::getClass()->orderFinish([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 预约成功通知
     *
     * @param  string $orderNum 订单id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendAppointmentNotice (string $orderNum) {
        return self::getClass()->sendAppointmentNotice([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 相框制作通知
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function makePhotoAlbum (string $orderNum) {
        return self::getClass()->makePhotoAlbum([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 物流发货通知
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function logistics (string $orderNum) {
        return self::getClass()->logistics([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 发送支付链接
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendPayUrl (string $orderNum) {
        return self::getClass()->sendPayUrl([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'MessageHook\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'MessageHook\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}