<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageQueue;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method orderFinishByParams(array $params)
 * @method sendNormalNotifyByParams(array $params)
 * @method makePhotoAlbumByParams(array $params)
 * @method logisticsByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 订单完成通知
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function orderFinish (string $orderNum) {
        return self::getClass()->orderFinish([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * Catalogue
     *
     * @support  int $orderId 订单id [ require true ]
     * @support  string $type 类型 [ require false ]
     * @support  string $module 订单模块 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendNormalNotify () {
        return self::getClass()->sendNormalNotify([
        ]);
    }

    /**
     * 相框制作通知
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function makePhotoAlbum (string $orderNum) {
        return self::getClass()->makePhotoAlbum([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * 物流发货通知
     *
     * @param  string $orderNum 订单编号 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function logistics (string $orderNum) {
        return self::getClass()->logistics([
            "orderNum" => $orderNum,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'MessageQueue\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'MessageQueue\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}