<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\MessageHook;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateStoreCacheByParams(array $params)
 * @method createStoreCacheByParams(array $params)
 * @method deleteStoreCacheByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 门店修改
     *
     * @param  array $attributes 新的门店信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateStoreCache (array $attributes) {
        return self::getClass()->updateStoreCache([
            "attributes" => $attributes,
        ]);
    }

    /**
     * 门店增加
     *
     * @param  string $store_type 新的门店信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function createStoreCache (string $store_type) {
        return self::getClass()->createStoreCache([
            "store_type" => $store_type,
        ]);
    }

    /**
     * 门店下架
     *
     * @param  array $store 新的门店信息 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteStoreCache (array $store) {
        return self::getClass()->deleteStoreCache([
            "store" => $store,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'MessageHook\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'MessageHook\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}