<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\ShareOrder;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method shareProductTagListByParams(array $params)
 * @method shareOrderDetailByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderInfoCmd $params)
 * @method shareOrderListByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderListCmd $params)
 * @method setIsLikeRecordByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\SetIsLikeRecordCmd $params)
 * @method getLikeRecordByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\GetIsLikeRecordCmd $params)
 */
class ShareOrder {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 买家秀标签列表
     *
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareProductTagDTO[]
     */
    public static function shareProductTagList () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareProductTagList(),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareProductTagDTO[]"
        );
    }

    /**
     * 买家秀详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderInfoCmd $shareOrderInfoCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderDetailDTO
     */
    public static function shareOrderDetail (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderInfoCmd $shareOrderInfoCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareOrderDetail($shareOrderInfoCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderDetailDTO"
        );
    }


    /**
     * 买家秀列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderListCmd $shareOrderListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderListDTO
     */
    public static function shareOrderList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\ShareOrderListCmd $shareOrderListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->shareOrderList($shareOrderListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\ShareOrder\ShareOrderListDTO"
        );
    }


    /**
     * 设置买家秀点赞信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\SetIsLikeRecordCmd $setIsLikeRecordCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function setIsLikeRecord (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\SetIsLikeRecordCmd $setIsLikeRecordCmd) {
        return self::getClass()->setIsLikeRecord($setIsLikeRecordCmd);
    }


    /**
     * 获取买家秀点赞信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\GetIsLikeRecordCmd $getIsLikeRecordCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getLikeRecord (\Mainto\Bridge\Structs\ProjectMainto\Cmd\ShareOrder\GetIsLikeRecordCmd $getIsLikeRecordCmd) {
        return self::getClass()->getLikeRecord($getIsLikeRecordCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'ShareOrder\ShareOrder');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'ShareOrder\ShareOrder');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}