<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getLogisticsInfoByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderLogisticsCmd $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取物流详情
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderLogisticsCmd $orderLogisticsCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderLogisticsDTO
     */
    public static function getLogisticsInfo (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Order\OrderLogisticsCmd $orderLogisticsCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getLogisticsInfo($orderLogisticsCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Order\OrderLogisticsDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}