<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Store;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCitiesByStoreTypeByParams(array $params)
 * @method getStoreListByCityIdByParams(array $params)
 * @method getStoreListByIdsByParams(array $params)
 */
class Store {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取当前有门店的所有城市
     *
     * @param  array $storeType 门店类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityStoreDTO[]
     */
    public static function getCitiesByStoreType (array $storeType) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCitiesByStoreType([
                            "storeType" => $storeType,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\CityStoreDTO[]"
        );
    }

    /**
     * 根据城市id获取门店列表
     *
     * @support  array $cityIds 城市ids [ require true ]
     * @support  array $storeType 门店类型 [ require true ]
     * @support  string $type 获取数据基本类型 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreAdvancedInfoDTO[]
     */
    public static function getStoreListByCityId () {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreListByCityId([
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreAdvancedInfoDTO[]"
        );
    }

    /**
     * 根据门店ids获取门店信息
     *
     * @param  array $storeIds 门店 [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO[]
     */
    public static function getStoreListByIds (array $storeIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getStoreListByIds([
                            "storeIds" => $storeIds,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Store\StoreBaseInfoDTO[]"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Store\Store');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Store\Store');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}