<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Reservation;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getReservationListByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Reservation\ReservationListCmd $params)
 */
class Reservation {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 排单表-单门店
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Reservation\ReservationListCmd $reservationListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Reservation\ReservationInfoDTO[]
     */
    public static function getReservationList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Reservation\ReservationListCmd $reservationListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getReservationList($reservationListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Reservation\ReservationInfoDTO[]"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Reservation\Reservation');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Reservation\Reservation');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}