<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Product;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCouldPhotoCityByParams(array $params)
 * @method getCouldPhotoStoreByParams(array $params)
 * @method addWantTakeProductByParams(array $params)
 * @method cancelWantTakeProductByParams(array $params)
 * @method productInfoByParams(array $params)
 * @method productListByParams(array $params)
 * @method productAllInfoByParams(array $params)
 * @method samplePieceByParams(array $params)
 * @method productSeriesListByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Product\ProductSeriesListCmd $params)
 */
class Product {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取产品可拍摄城市
     *
     * @param  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getCouldPhotoCity (int $productId) {
        return self::getClass()->getCouldPhotoCity([
            "productId" => $productId,
        ]);
    }

    /**
     * 获取产品可拍摄门店
     *
     * @param  array $productIds 产品Ids [ require true ]
     * @param  int $cityId 城市Id [ require true ]
     * @throws  \Exception
     * @return  int[]
     */
    public static function getCouldPhotoStore (array $productIds, int $cityId) {
        return self::getClass()->getCouldPhotoStore([
            "productIds" => $productIds,
            "cityId" => $cityId,
        ]);
    }

    /**
     * 添加想拍产品
     *
     * @param  int $productId 产品Id [ require true ]
     * @param  string $type 产品Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function addWantTakeProduct (int $productId, string $type) {
        return self::getClass()->addWantTakeProduct([
            "productId" => $productId,
            "type" => $type,
        ]);
    }

    /**
     * 取消想拍产品
     *
     * @param  int $productId 产品Id [ require true ]
     * @param  string $type 产品Id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function cancelWantTakeProduct (int $productId, string $type) {
        return self::getClass()->cancelWantTakeProduct([
            "productId" => $productId,
            "type" => $type,
        ]);
    }

    /**
     * 产品详情
     *
     * @param  int $productId 产品Id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO
     */
    public static function productInfo (int $productId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productInfo([
                            "productId" => $productId,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO"
        );
    }

    /**
     * 产品列表
     *
     * @param  array $productIds 产品Ids [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]
     */
    public static function productList (array $productIds) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productList([
                            "productIds" => $productIds,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]"
        );
    }

    /**
     * 全部产品
     *
     * @param  int $parentId 分类Id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function productAllInfo (int $parentId) {
        return self::getClass()->productAllInfo([
            "parentId" => $parentId,
        ]);
    }

    /**
     * 想拍产品列表
     *
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]
     */
    public static function samplePiece (int $page = 1, int $pageSize = 10) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->samplePiece([
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductInfoDTO[]"
        );
    }

    /**
     * 套系列表
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Product\ProductSeriesListCmd $productSeriesListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductSeriesListDTO
     */
    public static function productSeriesList (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Product\ProductSeriesListCmd $productSeriesListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->productSeriesList($productSeriesListCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Product\ProductSeriesListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Product\Product');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Product\Product');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}