<?php
namespace Mainto\Bridge\Invokes\ProjectMainto\Pay;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createPayOrderByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\CreatePayOrderCmd $params)
 * @method closePayOrderByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ClosePayOrderCmd $params)
 * @method getPaySignByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\PaySignCmd $params)
 * @method zeroPayByParams(array|\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ZeroPayCmd $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付单
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\CreatePayOrderCmd $createPayOrderCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\ProjectMainto\DTO\Pay\CreatePayOrderDTO
     */
    public static function createPayOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\CreatePayOrderCmd $createPayOrderCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->createPayOrder($createPayOrderCmd),
            "\Mainto\Bridge\Structs\ProjectMainto\DTO\Pay\CreatePayOrderDTO"
        );
    }


    /**
     * 关闭支付单
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function closePayOrder (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ClosePayOrderCmd $closePayOrderCmd) {
        return self::getClass()->closePayOrder($closePayOrderCmd);
    }


    /**
     * 获取支付凭证信息
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\PaySignCmd $paySignCmd
     * @throws  \Exception
     * @return  array
     */
    public static function getPaySign (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\PaySignCmd $paySignCmd) {
        return self::getClass()->getPaySign($paySignCmd);
    }


    /**
     * 零元支付
     *
     * @var  \Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ZeroPayCmd $zeroPayCmd
     * @throws  \Exception
     * @return  bool
     */
    public static function zeroPay (\Mainto\Bridge\Structs\ProjectMainto\Cmd\Pay\ZeroPayCmd $zeroPayCmd) {
        return self::getClass()->zeroPay($zeroPayCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMainto', 'Pay\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMainto', 'Pay\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}