<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setProtocolVersionByParams(array $params)
 * @method getUserInfoByParams(array $params)
 * @method editUserInfoByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method forgetUserPasswordByParams(array $params)
 * @method changUserPasswordByParams(array $params)
 * @method changeUserPasswordDirectByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocolVersion 预约协议版本 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProtocolVersion () {
        return self::getClass()->setProtocolVersion();
    }

    /**
     * 获取用户信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 修改用户信息
     *
     * @support  string $name 用户昵称 
     * @support  string $head_sculpture 用户头像 
     * @support  string $birth 用户生日 
     * @support  string $sex 用户性别 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserInfo () {
        return self::getClass()->editUserInfo();
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedback () {
        return self::getClass()->feedback();
    }

    /**
     * 通过验证码更改登录密码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forgetUserPassword (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPassword([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 更改密码
     *
     * @param  string $password 旧密码 [ require true ]
     * @param  string $passwordNew 新密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserPassword (string $password, string $passwordNew) {
        return self::getClass()->changUserPassword([
            "password" => $password,
            "passwordNew" => $passwordNew,
        ]);
    }

    /**
     * 更改密码（密码为空）
     *
     * @param  string $password 新密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changeUserPasswordDirect (string $password) {
        return self::getClass()->changeUserPasswordDirect([
            "password" => $password,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}