<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCategoriesForShareOrderByParams(array $params)
 * @method addShareOrderByParams(array $params)
 * @method deleteShareOrderByParams(array $params)
 * @method getShareOrderListByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得晒单类目数据
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCategoriesForShareOrder () {
        return self::getClass()->getCategoriesForShareOrder();
    }

    /**
     * 提交晒单数据
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $shareData 晒单数组 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addShareOrder () {
        return self::getClass()->addShareOrder();
    }

    /**
     * 删除晒单数据
     *
     * @support  int $shareId 买家秀ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteShareOrder () {
        return self::getClass()->deleteShareOrder();
    }

    /**
     * 获得买家秀列表
     *
     * @support  int $categoryId 类目ID [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getShareOrderList () {
        return self::getClass()->getShareOrderList();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}