<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAlbumsByParams(array $params)
 * @method addAlbumShareRecordByParams(array $params)
 * @method updateAlbumShareRecordByParams(array $params)
 * @method getAlbumShareRecordByParams(array $params)
 * @method saveAlbumByParams(array $params)
 */
class Album {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 我的相册列表
     *
     * @support  string $lastOrderReserveTime 上一页最后预约时间 
     * @support  int $page 分页 [Original type uint] 
     * @support  int $pageSize 每页数据量 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAlbums () {
        return self::getClass()->getAlbums();
    }

    /**
     * 共享记录保存.新增
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $photos 图片数据 [ require true ]
     * @support  int $shareType 分享类型，1为普通共享，2为指定共享 
     * @support  array $whitePhones 手机号数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function addAlbumShareRecord () {
        return self::getClass()->addAlbumShareRecord();
    }

    /**
     * 共享记录保存.更新
     *
     * @support  string $shareRecordId 共享记录id [ require true ]
     * @support  int $shareType 分享类型，1为普通共享，2为指定共享 [ require true ]
     * @support  array $whitePhones 手机号数据 
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateAlbumShareRecord () {
        return self::getClass()->updateAlbumShareRecord();
    }

    /**
     * 共享记录详情
     *
     * @support  string $shareRecordId 共享记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAlbumShareRecord () {
        return self::getClass()->getAlbumShareRecord();
    }

    /**
     * 保存到相册
     *
     * @support  string $shareRecordId 共享记录id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveAlbum () {
        return self::getClass()->saveAlbum();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\Album');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\Album');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}