<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getFrontendHostByParams(array $params)
 * @method identifyTextContentByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得前端域名
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getFrontendHost () {
        return self::getClass()->getFrontendHost();
    }

    /**
     * 文本内容校验
     *
     * @param  array $content 校验内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function identifyTextContent (array $content) {
        return self::getClass()->identifyTextContent([
            "content" => $content,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}