<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserProductCardByParams(array $params)
 * @method getAvailableListByParams(array $params)
 * @method bindProductCardByParams(array $params)
 */
class ProductCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得用户的产品体验券
     *
     * @support  string $status 优惠券状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserProductCard () {
        return self::getClass()->getUserProductCard();
    }

    /**
     * 获取用户下单可用产品券(含未失效但不可用)
     *
     * @support  array $productIds 产品ids [ require true ]
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAvailableList () {
        return self::getClass()->getAvailableList();
    }

    /**
     * 用户绑定产品券
     *
     * @support  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindProductCard () {
        return self::getClass()->bindProductCard();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\ProductCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\ProductCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}