<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserGiftCardByParams(array $params)
 * @method getUserGiftCardsByParams(array $params)
 * @method getGiftCardByOrderNumByParams(array $params)
 * @method chargeGiftCardByParams(array $params)
 * @method getGiveGiftCardByParams(array $params)
 * @method getGiveGiftCardDetailByParams(array $params)
 * @method receiveGiveByParams(array $params)
 * @method confirmGiveByParams(array $params)
 * @method cancelGiveByParams(array $params)
 * @method getGiftCardsByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method getCoverListByParams(array $params)
 * @method getTopicListByParams(array $params)
 * @method previewByParams(array $params)
 * @method setCoverByParams(array $params)
 * @method getBalanceByParams(array $params)
 * @method getGiftCardOrderListByParams(array $params)
 * @method getGiftCardOrderDetailByParams(array $params)
 * @method getGiftCardTransactionListByParams(array $params)
 * @method getGiftCardChargeRecordByParams(array $params)
 */
class GiftCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得用户礼品卡数据
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserGiftCard () {
        return self::getClass()->getUserGiftCard();
    }

    /**
     * 获取用户礼品卡列表
     *
     * @support  string $type 列表类型 
     * @support  string $sortField 排序字段 
     * @support  string $sortDirection 排序方向,desc/asc 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserGiftCards () {
        return self::getClass()->getUserGiftCards();
    }

    /**
     * 通过订单号获得用户礼品卡数据
     *
     * @support  string $orderNum 礼品卡订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCardByOrderNum () {
        return self::getClass()->getGiftCardByOrderNum();
    }

    /**
     * 充值礼品码
     *
     * @support  string $code 礼品码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function chargeGiftCard () {
        return self::getClass()->chargeGiftCard();
    }

    /**
     * 发送赠送邀请链接
     *
     * @support  int $gift_card_id 要送的礼品卡ID [ require true ]
     * @support  string $title 赠送标题 [ require true ]
     * @support  string $words 赠送语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiveGiftCard () {
        return self::getClass()->getGiveGiftCard();
    }

    /**
     * 获取赠送详情
     *
     * @support  string $code 加密后的赠送code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiveGiftCardDetail () {
        return self::getClass()->getGiveGiftCardDetail();
    }

    /**
     * 接受赠送
     *
     * @support  string $code 加密后的赠送code [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveGive () {
        return self::getClass()->receiveGive();
    }

    /**
     * 确认赠送
     *
     * @support  string $code 赠送记录code [ require true ]
     * @support  string $title 赠送标题 [ require true ]
     * @support  string $words 赠送语 
     * @throws  \Exception
     * @return  mixed
     */
    public static function confirmGive () {
        return self::getClass()->confirmGive();
    }

    /**
     * 取消赠送
     *
     * @support  int $cardId 赠送记录ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelGive () {
        return self::getClass()->cancelGive();
    }

    /**
     * 获得礼品卡包列表
     *
     * @support  int $page 分页 [Original type uint] 
     * @support  int $pageSize 每页数据量 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCards () {
        return self::getClass()->getGiftCards();
    }

    /**
     * 用户购买礼品卡
     *
     * @support  float $payMoney 实付 [Original type double] [ require true ]
     * @support  array $cardItem 卡片信息 [ require true ]
     * @support  array $extend 额外信息 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 获取用户可用封面信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCoverList () {
        return self::getClass()->getCoverList();
    }

    /**
     * 获取礼品卡类型信息
     *
     * @support  int $id 礼品卡topicId [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getTopicList () {
        return self::getClass()->getTopicList();
    }

    /**
     * 获取预览信息
     *
     * @support  string $code 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function preview () {
        return self::getClass()->preview();
    }

    /**
     * 设置cover
     *
     * @support  int $coverId 礼品卡id [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function setCover () {
        return self::getClass()->setCover();
    }

    /**
     * 获取用户余额
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getBalance () {
        return self::getClass()->getBalance();
    }

    /**
     * 获取礼品卡订单列表
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCardOrderList () {
        return self::getClass()->getGiftCardOrderList();
    }

    /**
     * 获取单个礼品卡订单详情
     *
     * @support  string $orderNum 礼品卡订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCardOrderDetail () {
        return self::getClass()->getGiftCardOrderDetail();
    }

    /**
     * 获取礼品卡交易明细
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCardTransactionList () {
        return self::getClass()->getGiftCardTransactionList();
    }

    /**
     * 获取礼品卡充值记录
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getGiftCardChargeRecord () {
        return self::getClass()->getGiftCardChargeRecord();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\GiftCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\GiftCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}