<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMessageListByParams(array $params)
 * @method getMessageStatusByUserIdByParams(array $params)
 * @method updateMessageStatusByUserIdByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取消息列表
     *
     * @support  int $page 分页 [Original type uint] 
     * @support  int $pageSize 每页数据量 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMessageList () {
        return self::getClass()->getMessageList();
    }

    /**
     * 获取消息状态是否未读
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMessageStatusByUserId () {
        return self::getClass()->getMessageStatusByUserId();
    }

    /**
     * 更新消息状态为已读
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateMessageStatusByUserId () {
        return self::getClass()->updateMessageStatusByUserId();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}