<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method setProtocolVersionByParams(array $params)
 * @method getUserInfoByParams(array $params)
 * @method editUserInfoByParams(array $params)
 * @method feedbackByParams(array $params)
 * @method forgetUserPasswordByParams(array $params)
 * @method changUserPasswordByParams(array $params)
 * @method getUserFlowByParams(array $params)
 * @method getUserWelfareListByParams(array $params)
 * @method alertCheckByParams(array $params)
 * @method cardCreateByParams(array $params)
 */
class User {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 记录预约协议版本
     *
     * @support  int $protocolVersion 预约协议版本 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function setProtocolVersion () {
        return self::getClass()->setProtocolVersion();
    }

    /**
     * 获取用户信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserInfo () {
        return self::getClass()->getUserInfo();
    }

    /**
     * 修改用户信息
     *
     * @support  string $name 用户昵称 
     * @support  string $head_sculpture 用户头像 
     * @support  string $birth 用户生日 
     * @support  string $sex 用户性别 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editUserInfo () {
        return self::getClass()->editUserInfo();
    }

    /**
     * 用户意见反馈
     *
     * @support  string $content 内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function feedback () {
        return self::getClass()->feedback();
    }

    /**
     * 通过验证码更改登录密码
     *
     * @param  string $phone 手机号 [ require true ]
     * @param  string $password 新密码 [ require true ]
     * @param  string $captcha 验证码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function forgetUserPassword (string $phone, string $password, string $captcha) {
        return self::getClass()->forgetUserPassword([
            "phone" => $phone,
            "password" => $password,
            "captcha" => $captcha,
        ]);
    }

    /**
     * 更改密码
     *
     * @param  string $password 旧密码 [ require true ]
     * @param  string $passwordNew 新密码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function changUserPassword (string $password, string $passwordNew) {
        return self::getClass()->changUserPassword([
            "password" => $password,
            "passwordNew" => $passwordNew,
        ]);
    }

    /**
     * 获取用户纪念值
     *
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @param  string $type 类型，支出 outcome, 默认收入 income [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserFlow (int $page, int $pageSize, string $type) {
        return self::getClass()->getUserFlow([
            "page" => $page,
            "pageSize" => $pageSize,
            "type" => $type,
        ]);
    }

    /**
     * 获得会员卡列表权益
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserWelfareList () {
        return self::getClass()->getUserWelfareList();
    }

    /**
     * 用户vip升级弹框标记
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function alertCheck () {
        return self::getClass()->alertCheck();
    }

    /**
     * 生成微信会员卡
     *
     * @support  string $scene 会员卡场景，预发为mantu_home，线上为himo [ require true ]
     * @support  string $brand 领取平台 
     * @support  string $openId 用户open_id 
     * @throws  \Exception
     * @return  mixed
     */
    public static function cardCreate () {
        return self::getClass()->cardCreate();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\User');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\User');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}