<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getInvoiceListByParams(array $params)
 * @method getInvoiceHistoryListByParams(array $params)
 * @method createSimpleByParams(array $params)
 * @method hmxStoreByParams(array $params)
 */
class Invoice {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取可开票的发票列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInvoiceList () {
        return self::getClass()->getInvoiceList();
    }

    /**
     * 获取发票列表.历史列表
     *
     * @support  int $page 页码 
     * @support  int $pageSize 条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInvoiceHistoryList () {
        return self::getClass()->getInvoiceHistoryList();
    }

    /**
     * 电子发票.开普票
     *
     * @support  string $code 短信验证码 [ require true ]
     * @support  array $orderNums 订单号 [ require true ]
     * @support  string $serviceType 服务类型 [ require true ]
     * @support  int $isNow 是否立即开具电子发票 [ require true ]
     * @support  string $name 购方名称 [ require true ]
     * @support  string $phone 购方手机，收验证码的手机号 [ require true ]
     * @support  array $detail 电子发票明细 [ require true ]
     * @support  string $message 备注信息 
     * @support  string $taxnum 购方税号(18/20位) 
     * @support  string $email 推送邮箱 
     * @support  string $telephone 购方电话 
     * @support  string $address 购方单位地址 
     * @support  string $account 购方银行账号(和开户行合在一起) 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createSimple () {
        return self::getClass()->createSimple();
    }

    /**
     * 开票主体门店(暂时只有海莫星)
     *
     * @throws  \Exception
     * @return  array
     */
    public static function hmxStore () {
        return self::getClass()->hmxStore();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\Invoice');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\Invoice');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}