<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method closeByParams(array $params)
 * @method payZeroByParams(array $params)
 */
class Pay {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建支付
     *
     * @support  string $orderNum 订单号 
     * @support  float $payMoney 金额 [Original type unsignedDouble] [ require true ]
     * @support  string $openId 用户openId 
     * @support  string $subOrderNum 二销订单编号 
     * @support  string $retailOrderNum 零售订单编号 
     * @support  string $offlineOrderNum 线下订单编号 
     * @support  array $payOrderMoney 支付金额组合 
     * @throws  \Exception
     * @return  array
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 关闭支付
     *
     * @support  string $orderNum 订单号 
     * @support  string $subOrderNum 子订单号 
     * @support  string $retailOrderNum 零售订单号 
     * @support  string $offlineOrderNum 线下订单号 
     * @support  string $groupOrderNum 团购订单号 
     * @support  int $groupOrderType 团购订单支付类型 
     * @throws  \Exception
     * @return  mixed
     */
    public static function close () {
        return self::getClass()->close();
    }

    /**
     * 零元支付
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function payZero () {
        return self::getClass()->payZero();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Order\Pay');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Order\Pay');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}