<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\User;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getUserPreferentialCardByParams(array $params)
 * @method getAvailableListByParams(array $params)
 * @method bindCouponByParams(array $params)
 * @method getSpringCouponInfoByParams(array $params)
 * @method bindSpringCouponByParams(array $params)
 */
class Preferential {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获得用户优惠券数据
     *
     * @support  string $status 优惠券状态 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserPreferentialCard () {
        return self::getClass()->getUserPreferentialCard();
    }

    /**
     * 获取用户下单可用优惠券(含未失效但不可用)
     *
     * @support  array $productIds 产品ids [ require true ]
     * @support  int $storeId 门店id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAvailableList () {
        return self::getClass()->getAvailableList();
    }

    /**
     * 用户绑定优惠券
     *
     * @support  string $preferentialCode 兑换码 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindCoupon () {
        return self::getClass()->bindCoupon();
    }

    /**
     * 春暖花开优惠券领取信息
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSpringCouponInfo () {
        return self::getClass()->getSpringCouponInfo();
    }

    /**
     * 领取春暖花开优惠券
     *
     * @support  int $index 产品下标 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindSpringCoupon () {
        return self::getClass()->bindSpringCoupon();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\User\Preferential');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\User\Preferential');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}