<?php
namespace Mainto\Bridge\Invokes\ProjectMaintoApp\V1\Order;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getOrderListByParams(array $params)
 * @method createOrderByParams(array $params)
 * @method getOrderDetailByParams(array $params)
 * @method cancelOrderByParams(array $params)
 * @method deleteOrderByParams(array $params)
 * @method getRefundReasonByParams(array $params)
 * @method getRefundToGiftCardByParams(array $params)
 * @method getRefundToRealMoneyByParams(array $params)
 * @method photoByParams(array $params)
 * @method getSubOrderServiceCompleteInfoByParams(array $params)
 * @method submitSubOrderServiceCompleteByParams(array $params)
 */
class Order {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取订单列表
     *
     * @support  string $status 订单状态-total:全部,wait:待拍摄,today:当日拍摄,complete:已完成,close:已关闭 [ require true ]
     * @support  int $page 页数 
     * @support  int $pageSize 每页条数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderList () {
        return self::getClass()->getOrderList();
    }

    /**
     * 创建订单
     *
     * @support  string $userPhone 用户手机号 [ require true ]
     * @support  string $userSex 用户性别 [ require true ]
     * @support  string $userName 用户姓名 [ require true ]
     * @support  string $userBirthday 用户生日 [ require true ]
     * @support  string $reserveTime 预约时间 [ require true ]
     * @support  array $detail 订单详情(商品&amp;服务详情) [ require true ]
     * @support  float $giftCardMoney 礼品卡抵扣金额 [Original type double] 
     * @support  int $couponId 优惠券ID 
     * @support  float $couponDeductionMoney 优惠券优惠金额 [Original type unsignedDouble] 
     * @support  int $productCardId 产品卡ID 
     * @support  float $productCardDeductionMoney 产品卡优惠金额 [Original type unsignedDouble] 
     * @support  array $productDiscountIds 组合优惠id 
     * @support  float $productDiscountDeductionMoney 组合优惠优惠金额 [Original type unsignedDouble] 
     * @support  int $storeId 门店id [ require true ]
     * @support  int $channel 渠道号，默认为0，市场部用于统计 
     * @support  string $note 备注 
     * @support  string $platform 平台，区分小程序和公众号，app暂使用mantu_app 
     * @support  float $oriMoney 原始价格，不包括折扣和优惠券 [Original type unsignedDouble] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrder () {
        return self::getClass()->createOrder();
    }

    /**
     * 获取订单详情
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getOrderDetail () {
        return self::getClass()->getOrderDetail();
    }

    /**
     * 取消未支付订单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function cancelOrder () {
        return self::getClass()->cancelOrder();
    }

    /**
     * 删除订单
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function deleteOrder () {
        return self::getClass()->deleteOrder();
    }

    /**
     * 获得退款理由
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundReason () {
        return self::getClass()->getRefundReason();
    }

    /**
     * 申请退款.礼品卡
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  array $reasonIds 退款原因ids 
     * @support  string $reason 退款原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundToGiftCard () {
        return self::getClass()->getRefundToGiftCard();
    }

    /**
     * 申请退款.现金
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @support  string $people 退款人 [ require true ]
     * @support  string $account 退款账户 [ require true ]
     * @support  array $reasonIds 退款原因ids [ require true ]
     * @support  string $reason 退款原因 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getRefundToRealMoney () {
        return self::getClass()->getRefundToRealMoney();
    }

    /**
     * 获取云端原片地址
     *
     * @support  string $orderNum 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function photo () {
        return self::getClass()->photo();
    }

    /**
     * 获取是否需要确认的子订单ids
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  array $subOrderItemIds 子订单项id，不是直接的子订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSubOrderServiceCompleteInfo (string $orderNo, array $subOrderItemIds = []) {
        return self::getClass()->getSubOrderServiceCompleteInfo([
            "orderNo" => $orderNo,
            "subOrderItemIds" => $subOrderItemIds,
        ]);
    }

    /**
     * 子订单确认
     *
     * @param  string $orderNo 订单号 [ require true ]
     * @param  array $subOrderIds 子订单id项 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function submitSubOrderServiceComplete (string $orderNo, array $subOrderIds) {
        return self::getClass()->submitSubOrderServiceComplete([
            "orderNo" => $orderNo,
            "subOrderIds" => $subOrderIds,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('ProjectMaintoApp', 'V1\Order\Order');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('ProjectMaintoApp', 'V1\Order\Order');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}